/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define M_PI (3.14159265359)

void main (void) {

	vec2 gRes = iResolution.xy;
	vec2 gPos = gl_FragCoord.xy/gRes;
	vec2 cRes = vec2(1.0,1.0); // iChannelResolution [0].xy;	
	vec2 cPos = (gPos - vec2 (0.5, 0.5))*2.0;
	
	float r = distance (cPos, vec2 (0.0));
	float a = atan (cPos.x, cPos.y) / (M_PI * 2.0);
	
	float r0 = mod (r + iGlobalTime/4.0, 1.0) ;
	float a0 = mod (a + iGlobalTime/8.0 + r, 1.0) ;
	
	float r1 = mod (r*0.125 + iGlobalTime/8.0, 1.0) ;
	float a1 = mod (a, 1.0) ;
	
	vec4 _0 = texture2D(iChannel0, vec2 (r0, a0));
	vec4 _1 = texture2D(iChannel1, vec2 (r1, a1));
	gl_FragColor =  _0 + _1*(1.0 - r)*0.6 + (1.0 - r)*0.7;

}